<?php


/**********************************************/ 
/* TEMP
/**********************************************/



/**********************************************/
/* Globals 
/**********************************************/

$Globals = array(
	'template_directory' 			=> get_bloginfo( "template_directory" ),
	'home_url'						=> get_bloginfo( "url" ),
	'site_url'						=> get_bloginfo( "url" ),
	'lang_code'						=> get_bloginfo( "language" )
);



add_theme_support('post-thumbnails');




/**********************************************/
/* Register menus
/**********************************************/
function hfe3_register_menus() {
	register_nav_menus( array(
		'primary' => __( 'Primary Menu', 'hfe3' )
	) );
	
	register_nav_menus( array(
		'footer' => __( 'Footer Menu', 'hfe3' )
	) );
}
add_action( 'after_setup_theme', 'hfe3_register_menus' );





/**********************************************/
/* Register widget areas
/**********************************************/
function hfe3_widgets_init() {

	register_sidebar( array(
		'name'          => 'Left sidebar',
		'id'            => 'left_sidebar',
		'before_widget' => '<div class="side-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3><div class="widget-content">',
	) );
	
	register_sidebar( array(
		'name'          => 'Right sidebar',
		'id'            => 'right_sidebar',
		'before_widget' => '<div class="side-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h3 class="widget-title">',
		'after_title'   => '</h3><div class="widget-content">',
	) );
	
	register_sidebar( array(
		'name'          => 'Footer column 1',
		'id'            => 'footer_col_1',
		'before_widget' => '<div class="footer-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4><div class="widget-content">',
	) );
	
	register_sidebar( array(
		'name'          => 'Footer column 2',
		'id'            => 'footer_col_2',
		'before_widget' => '<div class="footer-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4><div class="widget-content">',
	) );
	
	register_sidebar( array(
		'name'          => 'Footer column 3',
		'id'            => 'footer_col_3',
		'before_widget' => '<div class="footer-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4><div class="widget-content">',
	) );
	
	register_sidebar( array(
		'name'          => 'Footer column 4',
		'id'            => 'footer_col_4',
		'before_widget' => '<div class="footer-widget">',
		'after_widget'  => '</div></div>',
		'before_title'  => '<h4 class="widget-title">',
		'after_title'   => '</h4><div class="widget-content">',
	) );

}
add_action( 'widgets_init', 'hfe3_widgets_init' );




/**********************************************/
/* Register post types
/**********************************************/
function hfe3_register_post_types() {
	
	// Register new post type for organizers
	register_post_type( 'partener', array(
		'labels' => array(
			'name' 				=> __( 'Parteneri' ),
			'singular_name' 	=> __( 'Partener' ),
			'add_new'			=> __( 'Adauga partenri' ),
			'add_new_item' 		=> __( 'Adauga partener' ),
		),
		'public' 			=> true,
		'has_archive' 		=> true,
		//'taxonomies' 		=> array(),
		'supports' 			=> array('title', 'editor', 'excerpt', 'thumbnail'),
		'menu_position'		=> 20,
		'has_archive' 		=> true,
		'rewrite' 			=> array('slug' => 'partners')
    ) );
	////////
	
}
add_action( 'init', 'hfe3_register_post_types' );





/**********************************************/
/* Create new widget for organizers
/**********************************************/

/*
// Register and load the widget
function load_partners_widget() {
    register_widget( 'partners_widget' );
}
add_action( 'widgets_init', 'load_partners_widget' );
 
// Creating the widget 
class partners_widget extends WP_Widget {
	function __construct() {
		parent::__construct(
			// Base ID of your widget
			'partners_widget', 
			// Widget name will appear in UI
			__('Parteneri', 'hfe3'), 
			// Widget description
			array( 'description' => __( 'Lista de parteneri', 'hfe3' ), ) 
		);
	}
	
	// Creating widget front-end
	public function widget( $args, $instance ) {
		$title = apply_filters( 'widget_title', $instance['title'] );
		// before and after widget arguments are defined by themes
		echo $args['before_widget'];
		if ( ! empty( $title ) ) {
			echo $args['before_title'] . $title . $args['after_title'];
		}
		// This is where you run the code and display the output

		$posts = get_posts(array(
			'numberposts'	=> -1,
			'post_type'		=> 'partener',
			'meta_key'		=> 'partner_category',
			'meta_value'	=> $instance['group']
		));
		if( $posts ) : 
			global $post; ?>
			<div class="swiper-container widget-swiper" data-swiper-speed="300" data-swiper-loop="true" data-swiper-autoplay="true" data-swiper-autoplay-delay="2000">
				<div class="swiper-wrapper"><?php
					foreach( $posts as $post ) :
						setup_postdata( $post ); 
						$logo = get_field( 'partner_logo' );
						$name = get_field( 'partner_name' );
						if ( !$name ) {
							$name = get_the_title();
						}
						$link = get_field( 'partner_url' ); 
						?>
						<div class="swiper-slide widget-slide">
							<a href="<?php echo $link; ?>" target="_blank" title="<?php echo $name; ?>">
								<span class="widget-slide-image"><img src="<?php echo $logo; ?>" /></span>
								<span class="widget-slide-caption"><?php echo $name; ?></span>
							</a>	
						</div>
						<?php 
					endforeach;
					wp_reset_postdata();
				?>
				</div>
				<div class="swiper-pagination"></div>
			</div><?php
		else :
		endif;
		
		$extra = nl2br($instance['extra']);
		echo $extra;
		
		echo $args['after_widget'];
	}
	
	// Widget Backend 
	public function form( $instance ) {
		if ( isset( $instance[ 'title' ] ) ) {
			$title = $instance[ 'title' ];
		} else {
			$title = __( '', 'hfe3' );
		}
		if ( isset( $instance[ 'group' ] ) ) {
			$group = $instance[ 'group' ];
		} else {
			$group = 0;
		}
		if ( isset( $instance[ 'extra' ] ) ) {
			$extra = $instance[ 'extra' ];
		} else {
			$extra = '';
		}
		
		// Widget admin form
		?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'Title:' ); ?></label> 
			<input class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" type="text" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
			<label>Grupul afisat</label><br/>
			<input type="radio" name="<?php echo $this->get_field_name( 'group' ); ?>" id="partners-group-1" value="1" <?php if( $group === '1' ){ echo 'checked="checked"'; } ?> /> Organizatori &nbsp;&nbsp;&nbsp;
			<input type="radio" name="<?php echo $this->get_field_name( 'group' ); ?>" id="partners-group-2" value="2" <?php if( $group === '2' ){ echo 'checked="checked"'; } ?> /> Sponsori 
		</p>
		<p>
			<label>Continut suplimentar</label><br/>
			<textarea class="widefat" name="<?php echo $this->get_field_name( 'extra' ); ?>" id="<?php echo $this->get_field_id( 'extra' ); ?>" rows="6"><?php echo $extra; ?></textarea>
		</p>
		<?php 
	}
     
	// Updating widget replacing old instances with new
	public function update( $new_instance, $old_instance ) {
		$instance = array();
		$instance['title'] = ( ! empty( $new_instance['title'] ) ) ? strip_tags( $new_instance['title'] ) : '';
		$instance['group'] = strip_tags($new_instance['group']);
		$instance['extra'] = $new_instance['extra'];
		return $instance;
	}
} 
*/




/**********************************************/
/* Miscellaneous 
/**********************************************/









?>
