<?php
/**
 * The template for displaying the footer.
 *
 * Contains the closing of the #content div and all content after
 *
 * @package Online Coach
 */
?>


<?php if ( is_front_page() && ! is_home() ) { ?>
<?php if( get_theme_mod( 'hide_pagefourboxes' ) == '') { ?>

<section id="pagearea">
  <div class="container">
    <?php
$pages = array();
for ( $count = 1; $count<5; $count++ ) {
	$mod = get_theme_mod( 'page-column' . $count );
	if ( 'page-none-selected' != $mod ) {
		$pages[] = $mod;
	}
}
$filterArray = array_filter($pages);
if(count($filterArray) == 0){ ?>
	<?php if ( current_user_can( 'edit_theme_options' ) ) { ?>
    <p><img src="<?php echo esc_url(get_template_directory_uri()); ?>/images/home-boxes.jpg" /></p>
    <?php } ?>
    <?php 	
}else{

$filled_array=array_filter($pages);
	
$args = array(
	'posts_per_page' => 4,
	'post_type' => 'page',
	'post__in' => $pages,
	'orderby' => 'post__in'
);
$query = new WP_Query( $args );
if ( $query->have_posts() ) :
	$count = 1;
	while ( $query->have_posts() ) : $query->the_post();
	?>
    <div class="fourbox <?php if($count % 4 == 0) { echo "last_column"; } ?>"> 
      <?php if ( has_post_thumbnail() ) : ?>
      <div class="thumbbx">
        <?php the_post_thumbnail( array(30,30, true) );?>
      </div>
      <?php endif; ?>
      <h3>
        <?php the_title(); ?>
      </h3>
      <?php the_content(); ?> </div>
    <?php if($count == 0) { ?>
    <div class="clear"></div>
    <?php } ?>
    <?php
	$count++;
	endwhile;
 endif;
}
 
?>
    <div class="clear"></div>
  </div>
  <!-- container --> 
</section>
<!-- #pagearea -->
<?php } ?>

<?php } ?>


<?php 
/*
$sponsors_post = get_post( 446 ); 
if ( $sponsors_post ) { ?>
	<div id="sponsors-wrapper">
		<div class="container">
			<h1><?php echo $sponsors_post->post_title; ?></h1>
			<?php echo $sponsors_post->post_content; ?>
		</div>
	</div><?php
} 
*/
?>



<div id="footer-wrapper">
  <?php if( get_theme_mod( 'hide_footer' ) == '') { ?>
  <div class="footer">
    <div class="container">
      <div class="cols-4 widget-column-1">
        <?php 
                $about_title = get_theme_mod('about_title');
                if( !empty($about_title) ){ ?>
        <h5><?php echo esc_attr($about_title); ?></h5>
        <?php } ?>
        <?php 
                $about_description = get_theme_mod('about_description');
                if( !empty($about_description) ){ ?>
        <p><?php echo wp_kses_post($about_description); ?></p>
        <?php } ?>
      </div>
      <!--end .widget-column-1-->
      
      <div class="cols-4 widget-column-2">
        <?php 
                $menu_title = get_theme_mod('menu_title');
                if( !empty($menu_title) ){ ?>
        <h5><?php echo esc_attr($menu_title); ?></h5>
        <?php } ?>
        <div class="menu">
          <?php wp_nav_menu(array('theme_location' => 'footer')); ?>
        </div>
      </div>
      <!--end .widget-column-2-->
      
      <div class="cols-4 widget-column-3">
        <?php if ( ! dynamic_sidebar( 'footer-1' ) ) : ?>
        <?php 
            $newsfeed_title = get_theme_mod('newsfeed_title');
        ?> 
		<h5>&nbsp;</h5>
		<a href="http://www.healthfoodenviron.unitbv.ro/2014/">First edition: <br />Brașov, România, July 24-26, 2014</a>
		<br />
		<a href="http://www.healthfoodenviron.unitbv.ro/2015/">Second edition: <br />Brașov, România, September 3-5, 2015</a>
        <?php endif; ?>
      </div>
      <!--end .widget-column-3-->
      
      <div class="cols-4 widget-column-4">
        <?php 
                $contact_title = get_theme_mod('contact_title');
                if( !empty($contact_title) ){ ?>
        <h5><?php echo esc_attr($contact_title);?></h5>
        <?php } else { ?>
		<h5>&nbsp;</h5>
		<?php } ?>
        <div class="phone-no">
          <?php 
                $contact_add = get_theme_mod('contact_add');
				echo $contact_add;
          ?>
        </div>
        <div class="social-icons">
          <?php 
                    $fb_link = get_theme_mod('fb_link');
                    if( !empty($fb_link) ){ ?>
          <a title="facebook" class="fb" target="_blank" href="<?php echo esc_url($fb_link); ?>"></a>
          <?php } ?>
          <?php 
                    $twitt_link = get_theme_mod('twitt_link');
                    if( !empty($twitt_link) ){ ?>
          <a title="twitter" class="tw" target="_blank" href="<?php echo esc_url($twitt_link); ?>"></a>
          <?php } ?>
          <?php 
                    $gplus_link = get_theme_mod('gplus_link');
                    if( !empty($gplus_link) ){ ?>
          <a title="google-plus" class="gp" target="_blank" href="<?php echo esc_url($gplus_link); ?>"></a>
          <?php } ?>
          <?php 
                    $linked_link = get_theme_mod('linked_link');
                    if( !empty($linked_link) ){ ?>
          <a title="linkedin" class="in" target="_blank" href="<?php echo esc_url(get_theme_mod('linked_link','#linkedin')); ?>"></a>
          <?php } ?>
        </div>
      </div>
      <!--end .widget-column-4-->
      
      <div class="clear"></div>
    </div>
    <!--end .container--> 
  </div>
  <!--end .footer-->
  <?php } ?>
  <div class="copyright-wrapper">
    <div class="container">
      <div class="copyright-txt">
        <?php //esc_attr_e('&copy; 2016','online-coach');?>
        <?php bloginfo('name'); ?>
        .
        <?php// esc_attr_e('All Rights Reserved', 'online-coach');?>
      </div>
      <!--<div class="design-by"> <?php printf('<a target="_blank" href="'.esc_url(SKT_FREE_THEME_URL).'" rel="nofollow">Online Coach</a>' ); ?> </div>-->
      <div class="clear"></div>
    </div>
  </div>
</div>
<!--end .footer-wrapper-->
<?php wp_footer(); ?>
</body></html>