﻿/********************************************************************************/
/* Engine
/********************************************************************************/

Engine = {
	settings: {
		preloadClass			: 'preload'
	},
	
	
	globals: {
		// Status
		ready					: false,					// DOM is ready + all initializations done
		loaded					: false,					// DOM is ready + "preloadable" images are loaded
		started					: false,					// all done and application started
		
		// Layout
		windowWidth				: 0,
		windowHeight			: 0,
		layoutIdx				: 0,
		mobileLayout			: true,

		// Last item
		last					: true
	},


	
	
	
	/***********/
	/* PRIVATE METHODS
	/***********/
	create: function(){
		$(document).ready( this.onDocumentReady );
	},
	
	
	
	preload: function(container, complete) {
		
		function checkPreloadStatus() {
			preloadedCount++;
			if ( preloadedCount >= preloadableCount && typeof complete === 'function' ) {
				complete();
			} 
		}
		
		var preloadSelector = "." + Engine.settings.preloadClass,
			$preloadableItems = ( container instanceof jQuery ) ? container.find(preloadSelector) : ( container ? $(container).find(preloadSelector) : $(preloadSelector) ),
			preloadableCount = $preloadableItems.length;
		if ( preloadableCount > 0 ) {
			var preloadedCount = 0,
				images = [],
				k = 0;
			$preloadableItems.each(function(i) {
				var $item = $(this);
				if ( $item.is(':visible') ) {
					var src = '';	
					if ( $item[0].tagName == "IMG" ) {
						src = $item.attr('src');
					} else {
						src = $item.css('background-image');
						src = src.replace(/"/g,"").replace(/url\(|\)$/ig, "");
					}
					if ( src == '' || src == 'none' ) {
						preloadedCount++;
					} else {
						images[k] = new Image;
						images[k].src = src;
						images[k].onerror = checkPreloadStatus;
						images[k].onload = checkPreloadStatus;
						k++;
					}
				} else {
					preloadedCount++;
				}
			});
		} else {
			if ( typeof complete === 'function') {
				complete();
			}
		}
	},
	
	
	
	build: function(){
		
		/* Swipers */
		$('.swiper-container').each(function(idx, el){
			var $el = $(el);
			var params = {};
			var attr;
			
			// Speed
			attr = $el.data('swiper-speed');
			if ( typeof attr !== "undefined"  ) {
				attr = parseInt(attr);
				if ( attr != "NaN" ) {
					params.speed = {
						delay : attr
					};
				}
			}
			
			var speed = $el.data('swiper-speed');
			if ( typeof speed !== "undefined" ) {
				params.speed = speed
			}
			
			// Effect
			attr = $el.data('swiper-effect');
			if ( typeof attr !== "undefined" ) {
				params.effect = attr;
			}
			
			// Loop 
			attr = $el.data('swiper-loop');
			if ( typeof attr !== "undefined" && attr ) {
				params.loop = true;
			}
			
			// Autoplay ?
			attr = $el.data('swiper-autoplay');
			if ( typeof attr !== "undefined" && attr ) {
				params.autoplay = true;
				attr = $el.data('swiper-autoplay-delay');
				if ( typeof attr !== "undefined" ) {
					attr = parseInt(attr);
					if ( attr != "NaN" ) {
						params.autoplay = {
							delay : attr
						};
					}
				}
			}
			
			// Has pagination ?
			if ( $el.find('.swiper-pagination') ) {
				params.pagination = {
					el				: '.swiper-pagination',
					clickable		: true
				}
			}
			
			new Swiper(el, params);
		});
		/***/
		
		
		
		/* Toggle buttons */
		/*
		$('.toggle-btn').on('click', function(event){
			event.preventDefault();
			var target = $(this).data('toggle-target');
			if ( typeof target === 'undefined' ) {
				return false;
			}
			var className = $(this).data('toggle-class');
			if ( typeof className === 'undefined' ) {
				className = "on";
			}
			$(target).toggleClass(className);
			$(this).toggleClass(className);
			return true;
		});
		*/
		/***/
		
		
		
	},
	
	
	
	start: function() {
		if ( Engine.globals.started || !Engine.globals.ready || !Engine.globals.loaded ) {
			return false;
		}
		Engine.globals.started = true;
		$("#site-loader").removeClass('on');
		//Engine.onStart();
		setTimeout(function(){
			$("#site-loader").removeClass('animated');
			//$('.google-map').loadGoogleMap();
		}, 500);
	},
	
	
	
	hook: function(hookname) {
		
	},
	
	
	/***********/
	/* EVENTS
	/***********/
	onDocumentReady: function(){
		
		// Animate the loader, if not started
		setTimeout(function(){
			if ( !Engine.globals.started ) {
				$("#site-loader").addClass('animated');
			}
		}, 500);
		
		
		// Preload images (the sooner, the better)
		Engine.preload(false, function(){
			Engine.globals.loaded = true;
			Engine.start();
		});
		
		
		// Collect viewport data
		Engine.globals.mobileLayout	= ( Engine.globals.windowWidth < 1200 );
		
		
		// Initialize all 'fancy' elements 
		Engine.build();
		
		
		// Let's start
		Engine.globals.ready = true;
		Engine.start();
	},
	
};

Engine.create();
